local t = Def.ActorFrame{}

--Header
t[#t+1] = StandardDecorationFromFileOptional("Header","Header");

--SONG INFO
t[#t+1] = LoadActor(THEME:GetPathG("","SongInfo"))..{}
t[#t+1] = LoadActor(THEME:GetPathG("","ShiftFrame"))..{}

--Header Parts--
t[#t+1] = LoadFont("RX") .. {
	InitCommand=cmd(draworder,15;zoom,0.6;x,SCREEN_CENTER_X+64;y,SCREEN_TOP-40;diffuse,0,.5,1,1;diffusetopedge,0,1,1,1;horizalign,center;maxwidth,64;shadowlength,0.8;sleep,0.45;linear,0.35;addy,64);
	OnCommand=function(self)
		local stageNum=GAMESTATE:GetCurrentStageIndex()+1
		if stageNum < 10 then
			self:settext("0"..stageNum);
		else
			self:settext(stageNum);
		end
	end
}
t[#t+1] = LoadFont("RX") .. {
	Text="Select";
	InitCommand=cmd(horizalign,center;maxwidth,220;zoom,0.6;y,SCREEN_TOP-50;x,SCREEN_CENTER_X;vertalign,bottom;shadowlength,0.8;diffuse,0,.5,1,1;diffusetopedge,0,1,1,1;queuecommand,"Set");
	OnCommand=cmd(sleep,0.45;linear,.35;addy,64);
	OffCommand=cmd(linear,.25;addy,-64);
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
			self:diffusealpha(1);
		else
			self:diffusealpha(0.8);
		end
	end
};
t[#t+1] = LoadFont("RX")..{
		InitCommand=cmd(draworder,2;diffuse,0,.5,1,1;diffusetopedge,0,1,1,1;shadowlength,0.8;maxwidth,256;horizalign,center;vertalign,top;y,SCREEN_TOP-40;x,SCREEN_CENTER_X;zoom,0.6;queuecommand,"Set");
		OnCommand=cmd(sleep,0.45;linear,.35;addy,64);
		OffCommand=cmd(linear,.25;addy,-64);
		SetCommand=function(self)
			local bns=GAMESTATE:GetCurrentStage();
			if bns == "Stage_Extra1" or bns == "Stage_Extra2" then
				self:settext("Music");
			else
				self:settext("Music");
			end
		end;
		SongChosenMessageCommand=cmd(settext,"Mode");
		TwoPartConfirmCanceledMessageCommand=cmd(playcommand,"Set");
		SongUnchosenMessageCommand=cmd(playcommand,"Set");
};
--[[
t[#t+1] = LoadActor("long_normal") .. {
	InitCommand=cmd(draworder,25;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+4;zoom,0.65);
	SongChosenMessageCommand=cmd(diffusealpha,0);
	TwoPartConfirmCanceledMessageCommand=cmd(diffusealpha,1);
	SongUnchosenMessageCommand=cmd(diffusealpha,1);
	--PlayerJoinedMessageCommand=cmd(playcommand,"Init");
	CurrentSongChangedMessageCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
		self:visible(song:IsLong());
		else
		self:visible(false)
		end
	end;
}; 
t[#t+1] = LoadActor("marathon_normal") .. {
	InitCommand=cmd(draworder,25;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+4;zoom,0.65);
	SongChosenMessageCommand=cmd(diffusealpha,0);
	TwoPartConfirmCanceledMessageCommand=cmd(diffusealpha,1);
	SongUnchosenMessageCommand=cmd(diffusealpha,1);
	--PlayerJoinedMessageCommand=cmd(playcommand,"Init");
	CurrentSongChangedMessageCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
		self:visible(song:IsMarathon());
		else
		self:visible(false)
		end
	end;
}; 
]]

--GROUP--
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_LEFT-256;y,SCREEN_TOP-36);
	OnCommand=cmd(sleep,0.45;linear,.35;addx,256;addy,64);
	OffCommand=cmd(linear,.25;addx,-256;addy,-64);
	Def.Quad {
		InitCommand=cmd(horizalign,left;vertalign,bottom;zoomto,220,28;diffuse,0,0,0,.75;faderight,0.25);
	};
	Def.Quad{
		InitCommand=cmd(horizalign,left;vertalign,bottom;zoomto,192,2;y,-2;diffuse,.5,.5,.5,.75;faderight,0.25;rainbow;effectclock,"bgm";effecttiming,7,0,0,0);
	};
	Def.Quad {
		InitCommand=cmd(horizalign,left;vertalign,top;zoomto,96,24;diffuse,0,0,0,.75;faderight,0.25);
	};
	Def.Quad{
		InitCommand=cmd(horizalign,left;vertalign,top;zoomto,96,2;y,20;diffuse,.5,.5,.5,.75;faderight,0.25;rainbow;effectclock,"bgm";effecttiming,7,0,0,0);
	};
	LoadFont("RX") .. {
	Text="Group";
	InitCommand=cmd(horizalign,center;maxwidth,220;zoom,0.5;y,0;x,78;vertalign,bottom;shadowlength,0.8;diffuse,0,.5,1,1;diffusetopedge,0,1,1,1;queuecommand,"Set");
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
			self:diffusealpha(1);
		else
			self:diffusealpha(0.8);
		end
	end
	};

	LoadFont("RX") .. {
	Text="Sort";
	InitCommand=cmd(horizalign,center;maxwidth,220;zoom,0.4;y,20;x,24;vertalign,top;shadowlength,0.8;diffuse,0,.5,1,1;diffusetopedge,0,1,1,1;queuecommand,"Set");
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
			self:diffusealpha(1);
		else
			self:diffusealpha(0.8);
		end
	end
	};
	LoadFont("RX")..{
	InitCommand=cmd(draworder,2;horizalign,left;x,8;y,-10;zoom,0.8;vertalign,bottom;maxwidth,256;diffusetopedge,0,.5,1,1;shadowlength,0.8);
	CurrentSongChangedMessageCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
			self:settext(song:GetGroupName());
			self:diffusealpha(1);
		else
			self:settext("Unknown")
			self:diffusealpha(0);
		end
	end;
	OffCommand=cmd(bouncebegin,0.15;zoomy,0;);
	};
	StandardDecorationFromFileOptional("SortOrder","SortOrderText") .. {
	BeginCommand=cmd(draworder,2;horizalign,left;x,8;y,12;playcommand,"Set");
	SortOrderChangedMessageCommand=cmd(playcommand,"Set";);
	SetCommand=function(self)
		local s = SortOrderToLocalizedString( GAMESTATE:GetSortOrder() );
		local g = GAMESTATE:GetSortOrder()

		if g == "SortOrder_Preferred" then
			self:settext("ALL TUNES");
			self:playcommand("Sort");
		else
			self:settext( s );
			self:playcommand("Sort");
		end
	end;
	};
};

--GENRE
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_RIGHT+256;y,SCREEN_TOP-36);
	OnCommand=cmd(sleep,0.45;linear,.35;addx,-256;addy,64);
	OffCommand=cmd(linear,.25;addx,256;addy,-64);
	Def.Quad {
		InitCommand=cmd(horizalign,right;vertalign,bottom;zoomto,220,28;diffuse,0,0,0,.75;fadeleft,0.25);
	};
	Def.Quad{
		InitCommand=cmd(horizalign,right;vertalign,bottom;zoomto,192,2;y,-2;diffuse,.5,.5,.5,.75;fadeleft,0.25;rainbow;effectclock,"bgm";effecttiming,7,0,0,0);
	};
	Def.Quad {
		InitCommand=cmd(horizalign,right;vertalign,top;zoomto,144,24;diffuse,0,0,0,.75;fadeleft,0.25);
	};
	Def.Quad{
		InitCommand=cmd(horizalign,right;vertalign,top;zoomto,144,2;y,20;diffuse,.5,.5,.5,.75;fadeleft,0.25;rainbow;effectclock,"bgm";effecttiming,7,0,0,0);
	};
	LoadFont("RX") .. {
	Text="Genre";
	InitCommand=cmd(horizalign,center;maxwidth,256;zoom,0.5;y,0;x,-78;vertalign,bottom;shadowlength,0.8;diffuse,0,.5,1,1;diffusetopedge,0,1,1,1;queuecommand,"Set");
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
			self:diffusealpha(1);
		else
			self:diffusealpha(0.8);
		end
	end
	};
	LoadFont("RX") .. {
	Text="Origin";
	InitCommand=cmd(horizalign,center;maxwidth,220;zoom,0.4;y,20;x,-24;vertalign,top;shadowlength,0.8;diffuse,0,.5,1,1;diffusetopedge,0,1,1,1;queuecommand,"Set");
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
			self:diffusealpha(1);
		else
			self:diffusealpha(0.8);
		end
	end
	};
	LoadFont("RX") .. {
	InitCommand=cmd(horizalign,right;maxwidth,256;zoom,0.6;y,14;x,-6;vertalign,bottom;shadowlength,0.8;diffusetopedge,0,.5,1,1;queuecommand,"Set");
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		local ori = GAMESTATE:GetCurrentSong():GetOrigin();
			if song then
			if ori == "" then
				self:settext("Unknown");
			else
				self:settext(ori);
			end
				self:settext(ori);
			end
	end
	};
};
t[#t+1] = LoadActor( "GenreContent.lua" ) .. {
	InitCommand = cmd(x,SCREEN_RIGHT+248;y,SCREEN_TOP-48;draworder,2;zoom,0.8);
	OnCommand=cmd(sleep,0.45;linear,.35;addx,-256;addy,64);
	OffCommand=cmd(linear,.25;addx,256;addy,-64);
		SetCommand=function(self)
			local song = GAMESTATE:GetCurrentSong();
			if song then
				self:visible(true);
			else
				self:visible(false);
			end
		end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
	OffCommand=cmd(bouncebegin,0.15;zoomy,0;);
}

--CENTER INFO--
--BPM
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(draworder,15;x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-128);
	OnCommand=cmd(sleep,0.45;linear,.35;diffusealpha,1);
	OffCommand=cmd(linear,.25;diffusealpha,0);
	
	Def.Quad {
		InitCommand=cmd(x,0;y,-2;zoomto,148,18;diffuse,0,0,0,1;fadeleft,0.35;faderight,0.35);
	};
	LoadFont("RX")..{
		Text="BPM";
	InitCommand=cmd(diffuse,0,.5,1,1;diffusetopedge,0,1,1,1;draworder,5;horizalign,right;x,-4;zoomx,0.75;zoomy,0;shadowlength,1;sleep,.5;linear,.35;zoomy,0.75);
	OffCommand=cmd(linear,.35;zoomy,0);
	}
};
t[#t+1] = 	StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay")..{
	InitCommand=cmd(draworder,16);
}

--P1 MODE INFO
t[#t+1] = LoadActor(THEME:GetPathG("","P1Steps"))..{
	InitCommand=cmd(draworder,5;x,SCREEN_LEFT-70;y,SCREEN_CENTER_Y+74;zoom,1.25;sleep,0.45;linear,0.25;addx,128);
	OnCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1));
	OffCommand=cmd(linear,0.25;addx,-128);
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1));
}

t[#t+1] = Def.ActorFrame {
InitCommand=cmd(draworder,4;visible,true;x,SCREEN_LEFT-78;y,SCREEN_CENTER_Y+4;sleep,0.45;linear,0.25;addx,128);
SongChosenMessageCommand=cmd(visible,true);
TwoPartConfirmCanceledMessageCommand=cmd(visible,true);
SongUnchosenMessageCommand=cmd(visible,true);
PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);playcommand,"Init");

	Def.Quad {
	InitCommand=cmd(diffuse,color("0,0,0,1");x,0;y,-2;zoomto,102,44;faderight,0.33);
	};
	Def.Quad {
	InitCommand=cmd(diffuse,color("0,0,0,1");x,0;y,-8;zoomto,96,1;faderight,0.5;rainbow;effectclock,"bgm";effecttiming,7,0,0,0);
	};
	LoadFont("RX") .. {
	InitCommand=cmd(maxwidth,256;draworder,6;horizalign,center;x,0;y,-12;zoom,0.55;shadowlength,0.8;diffuse,0,.75,.5,1;diffusetopedge,0,1,1,1;queuecommand,"Set");
	OnCommand=cmd(queuecommand,"Set");
	PlayerJoinedMessageCommand=cmd(queuecommand,"Set");
	PlayerUnjoinedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
		local profile = PROFILEMAN:GetProfile(PLAYER_1);
		local name = profile:GetDisplayName();
		if GAMESTATE:IsHumanPlayer(PLAYER_1) == true then
			if name=="" then
				self:settext("P1");
			else
				self:settext( name );
			end
		end
	end;
	};
	Def.Sprite {
	InitCommand=cmd(draworder,4;x,28;y,8;zoom,0.3;visible,GAMESTATE:IsHumanPlayer(PLAYER_1));
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP1ChangedMessageCommand=cmd(queuecommand,"Set");
	PlayerJoinedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
	local song = GAMESTATE:GetCurrentSong();
		if song then
			self:diffusealpha(1);
			profile = PROFILEMAN:GetMachineProfile();
			scorelist = profile:GetHighScoreList(GAMESTATE:GetCurrentSong(),GAMESTATE:GetCurrentSteps(PLAYER_1));
			assert(scorelist);
			local scores = scorelist:GetHighScores();
			local topscore = scores[1];
				if topscore then 
							local dancepoints = topscore:GetPercentDP()*100
							local misses = topscore:GetTapNoteScore("TapNoteScore_Miss")+topscore:GetTapNoteScore("TapNoteScore_CheckpointMiss")
							local grade;
					if dancepoints >= 50 then
						grade = "Tier06";
						if dancepoints >= 60 then
							grade = "Tier05";
							if dancepoints >= 70 then
								grade = "Tier04";
								if dancepoints >= 80 then
									grade = "Tier03";
									if misses==0 then
										grade = "Tier02";
										if dancepoints >= 99 then
											grade = "Tier01";
											if dancepoints == 100 then
												grade = "Tier00";
											end
										end
									end
								end	
							end
						end
					else 
						grade = "Tier07";
					end
				self:Load(THEME:GetPathG("","GradeDisplayPane/"..grade));
			else
				--if no score
				self:diffusealpha(0);
			end
		else
			--if no song
			self:diffusealpha(0);
		end;
	end;
	};
	LoadFont("RX")..{
	InitCommand=cmd(shadowlength,0.8;horizalign,left;draworder,10;x,-36;y,2;zoom,0.5;diffuse,0,.75,.5,1;diffusetopedge,0,1,1,1;visible,GAMESTATE:IsHumanPlayer(PLAYER_1);queuecommand,"Set");
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP1ChangedMessageCommand=cmd(queuecommand,"Set");
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);queuecommand,"Set");
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong();
		if song then
			profile = PROFILEMAN:GetMachineProfile();
			scorelist = profile:GetHighScoreList(GAMESTATE:GetCurrentSong(),GAMESTATE:GetCurrentSteps(PLAYER_1));
			assert(scorelist);
			local scores = scorelist:GetHighScores();
			local topscore = scores[1];
			if topscore then
					text = topscore:GetName();
			else
					text = "Best";
			end
			
			self:diffusealpha(1);
			if text=="EVNT" then
				self:settext("Best");
			else
				self:settext(text);
			end
		else
			self:settext("Best");
			self:diffusealpha(0.8);
		end
	end
};

LoadFont("RX")..{
	InitCommand=cmd(shadowlength,0.8;horizalign,left;draworder,5;x,-40;y,14;zoom,0.5;diffuse,0,.75,.5,1;diffusetopedge,0,1,1,1;visible,GAMESTATE:IsHumanPlayer(PLAYER_1);queuecommand,"Set");
		CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
		CurrentStepsP1ChangedMessageCommand=cmd(queuecommand,"Set");
		PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);queuecommand,"Set");
		SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong();
		if song then
			profile = PROFILEMAN:GetMachineProfile();
			scorelist = profile:GetHighScoreList(GAMESTATE:GetCurrentSong(),GAMESTATE:GetCurrentSteps(PLAYER_1));
			assert(scorelist);
			local scores = scorelist:GetHighScores();
			local topscore = scores[1];
			if topscore then
					if string.find(PREFSMAN:GetPreference("VideoRenderers"), "d3d,") then
						text = math.floor(topscore:GetPercentDP()*100).."%"
					else
						text = (((math.floor(topscore:GetPercentDP()*10000))/100).."%");
					end
			else
					text = "0%";
			end
			self:diffusealpha(1);
			self:settext(text);	
		else
			self:settext("0%");
			self:diffusealpha(0.8);
		end
		end;
	};
	LoadFont("RX")..{
	Text="PRESS";
	InitCommand=cmd(uppercase,true;draworder,106;horizalign,center;x,-6;y,-14;shadowlength,1;zoom,0.5;diffuseshift;effectcolor1,color("#00995099");effectcolor2,color("#009950FF");effectperiod,1;playcommand,"RefreshP1");
	PlayerJoinedMessageCommand=cmd(playcommand,"RefreshP1");
	CoinModeChangedMessageCommand=cmd(playcommand,"RefreshP1");
	CoinInsertedMessageCommand=cmd(playcommand,"RefreshP1");
	RefreshP1Command=function(self)
		self:hidden(GAMESTATE:IsHumanPlayer(PLAYER_1))
	end;
	};
	LoadActor("start")..{
	InitCommand=cmd(draworder,106;horizalign,center;x,-6;y,4;zoom,0.5;diffuseshift;effectcolor1,color("#FFFFFF99");effectcolor2,color("#FFFFFFFF");effectperiod,1;playcommand,"RefreshP1");
	PlayerJoinedMessageCommand=cmd(playcommand,"RefreshP1");
	CoinModeChangedMessageCommand=cmd(playcommand,"RefreshP1");
	CoinInsertedMessageCommand=cmd(playcommand,"RefreshP1");
	RefreshP1Command=function(self)
		self:hidden(GAMESTATE:IsHumanPlayer(PLAYER_1))
	end;
	};
};


--P2 MODE INFO
t[#t+1] = LoadActor(THEME:GetPathG("","P2Steps"))..{
	InitCommand=cmd(draworder,5;x,SCREEN_RIGHT+70;y,SCREEN_CENTER_Y+74;zoom,1.25;sleep,0.45;linear,0.25;addx,-128);
	OnCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2));
	OffCommand=cmd(linear,0.25;addx,128);
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2));
}
t[#t+1] = Def.ActorFrame {
InitCommand=cmd(draworder,4;visible,true;x,SCREEN_RIGHT+78;y,SCREEN_CENTER_Y+4;sleep,0.45;linear,0.25;addx,-128);
SongChosenMessageCommand=cmd(visible,true);
TwoPartConfirmCanceledMessageCommand=cmd(visible,true);
SongUnchosenMessageCommand=cmd(visible,true);
PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);playcommand,"Init");

	Def.Quad {
	InitCommand=cmd(diffuse,color("0,0,0,1");x,0;y,-2;zoomto,102,44;faderight,0.0;fadeleft,0.33);
	};
	Def.Quad {
	InitCommand=cmd(diffuse,color("0,0,0,1");x,0;y,-8;zoomto,96,1;fadeleft,0.5;rainbow;effectclock,"bgm";effecttiming,7,0,0,0);
	};
	LoadFont("RX") .. {
	InitCommand=cmd(maxwidth,256;draworder,6;horizalign,center;x,0;y,-12;zoom,0.55;shadowlength,0.8;diffuse,0,.8,1,1;diffusetopedge,0,1,1,1;uppercase,false;queuecommand,"Set");
	OnCommand=cmd(queuecommand,"Set");
	PlayerJoinedMessageCommand=cmd(queuecommand,"Set");
	PlayerUnjoinedMessageCommand=cmd(queuecommand,"Set");
	SetCommand=function(self)
		local profile = PROFILEMAN:GetProfile(PLAYER_2);
		local name = profile:GetDisplayName();
		if GAMESTATE:IsHumanPlayer(PLAYER_2) == true then
			if name=="" then
				self:settext("P2");
			else
				self:settext( name );
			end
		end
	end;
	};
	Def.Sprite {
	InitCommand=cmd(draworder,4;x,28;y,8;zoom,0.3;visible,GAMESTATE:IsHumanPlayer(PLAYER_2));
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);queuecommand,"Set");
	SetCommand=function(self)
	local song = GAMESTATE:GetCurrentSong();
		if song then
			self:diffusealpha(1);
			profile = PROFILEMAN:GetMachineProfile();
			scorelist = profile:GetHighScoreList(GAMESTATE:GetCurrentSong(),GAMESTATE:GetCurrentSteps(PLAYER_2));
			assert(scorelist);
			local scores = scorelist:GetHighScores();
			local topscore = scores[1];
				if topscore then 
							local dancepoints = topscore:GetPercentDP()*100
							local misses = topscore:GetTapNoteScore("TapNoteScore_Miss")+topscore:GetTapNoteScore("TapNoteScore_CheckpointMiss")
							local grade;
					if dancepoints >= 50 then
						grade = "Tier06";
						if dancepoints >= 60 then
							grade = "Tier05";
							if dancepoints >= 70 then
								grade = "Tier04";
								if dancepoints >= 80 then
									grade = "Tier03";
									if misses==0 then
										grade = "Tier02";
										if dancepoints >= 99 then
											grade = "Tier01";
											if dancepoints == 100 then
												grade = "Tier00";
											end
										end
									end
								end	
							end
						end
					else 
						grade = "Tier07";
					end
				--SCREENMAN:SystemMessage(grade);
				self:Load(THEME:GetPathG("","GradeDisplayPane/"..grade));
			else
				--if no score
				self:diffusealpha(0);
			end
		else
			--if no song
			self:diffusealpha(0);
		end;
	end;
	};

LoadFont("RX")..{
	InitCommand=cmd(shadowlength,0.8;horizalign,left;draworder,10;x,-36;y,2;zoomx,0.5;zoomy,0.5;diffuse,0,.8,1,1;diffusetopedge,0,1,1,1;visible,GAMESTATE:IsHumanPlayer(PLAYER_2);queuecommand,"Set");
	CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
	CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);queuecommand,"Set");
	SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong();
		if song then
			profile = PROFILEMAN:GetMachineProfile();
			scorelist = profile:GetHighScoreList(GAMESTATE:GetCurrentSong(),GAMESTATE:GetCurrentSteps(PLAYER_2));
			assert(scorelist);
			local scores = scorelist:GetHighScores();
			local topscore = scores[1];
			if topscore then
					text = topscore:GetName();
			else
					text = "Best";
			end
			
			self:diffusealpha(1);
			if text=="EVNT" then
				self:settext("Best");
			else
				self:settext(text);
			end
		else
			self:settext("Best");
			self:diffusealpha(0.8);
		end
	end
};

LoadFont("RX")..{
	InitCommand=cmd(shadowlength,0.8;horizalign,left;draworder,5;x,-40;y,14;zoom,0.5;diffuse,0,.8,1,1;diffusetopedge,0,1,1,1;visible,GAMESTATE:IsHumanPlayer(PLAYER_2);queuecommand,"Set");
		CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
		CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set");
		PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);queuecommand,"Set");
		SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong();
		if song then
			profile = PROFILEMAN:GetMachineProfile();
			scorelist = profile:GetHighScoreList(GAMESTATE:GetCurrentSong(),GAMESTATE:GetCurrentSteps(PLAYER_2));
			assert(scorelist);
			local scores = scorelist:GetHighScores();
			local topscore = scores[1];
			if topscore then
					if string.find(PREFSMAN:GetPreference("VideoRenderers"), "d3d,") then
						text = math.floor(topscore:GetPercentDP()*100).."%"
					else
						text = (((math.floor(topscore:GetPercentDP()*10000))/100).."%");
					end
			else
					text = "0%";
			end
			self:diffusealpha(1);
			self:settext(text);	
		else
			self:settext("0%");
			self:diffusealpha(0.8);
		end
		end;
	};
	LoadFont("RX")..{
	Text="PRESS";
	InitCommand=cmd(draworder,10;horizalign,center;x,6;y,-14;shadowlength,1;zoom,0.5;diffuseshift;effectcolor1,color("#0080FF99");effectcolor2,color("#0080FFFF");effectperiod,1;playcommand,"RefreshP2");
	PlayerJoinedMessageCommand=cmd(playcommand,"RefreshP2");
	CoinModeChangedMessageCommand=cmd(playcommand,"RefreshP2");
	CoinInsertedMessageCommand=cmd(playcommand,"RefreshP2");
	RefreshP2Command=function(self)
		self:hidden(GAMESTATE:IsHumanPlayer(PLAYER_2))
	end;
	};
	LoadActor("start")..{
	InitCommand=cmd(draworder,10;horizalign,center;x,6;y,4;zoom,0.5;diffuseshift;effectcolor1,color("#FFFFFF99");effectcolor2,color("#FFFFFFFF");effectperiod,1;playcommand,"RefreshP2");
	PlayerJoinedMessageCommand=cmd(playcommand,"RefreshP2");
	CoinModeChangedMessageCommand=cmd(playcommand,"RefreshP2");
	CoinInsertedMessageCommand=cmd(playcommand,"RefreshP2");
	RefreshP2Command=function(self)
		self:hidden(GAMESTATE:IsHumanPlayer(PLAYER_2))
	end;
	}
};


---PREVIEW
t[#t+1] = LoadActor("../Frame Center") .. {
	InitCommand=cmd(draworder,1;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;rainbow;effectclock,"bgm";effecttiming,7,0,0,0);
	CurrentSongChangedMessageCommand=function(self)
		local song = GAMESTATE:GetCurrentSong();
		if song then
			self:diffusealpha(1);
		else
			self:diffusealpha(1);
		end
	end;
}

t[#t+1] = Def.Sprite {
	InitCommand=cmd(draworder,0;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;stoptweening);
	ChangeCommand=function(self)
		if (GAMESTATE:GetCurrentSong():HasPreviewVid()) and (FILEMAN:DoesFileExist(GAMESTATE:GetCurrentSong():GetPreviewVidPath())) then
			self:Load(GAMESTATE:GetCurrentSong():GetPreviewVidPath());
			self:stoptweening();
			self:rate(1.000);
		else
			self:Load(GAMESTATE:GetCurrentSong():GetBackgroundPath());
			self:stoptweening();
			self:rate(1.000);
		end;
		(cmd(scaletoclipped,640,360;cropbottom,18/360;croptop,18/360;diffuse,0,0,0,1;linear,0.12;diffuse,1,1,1,1))(self);
	end;
	OnCommand=cmd(stoptweening;playcommand,'Change';pause;diffusealpha,0;play;diffuse,1,1,1,1);
	PreviewChangedCommand=cmd(stoptweening;diffusealpha,1;sleep,0.15;queuecommand,'Change');
	FadeOutCommand=cmd(stoptweening;linear,0.15;diffuse,0,0,0,1);
	CurrentSongChangedMessageCommand=cmd(finishtweening;sleep,0.15;queuecommand,"Change");
};

--TEST--
--t[#t+1] = LoadActor("World Max")..{}

t[#t+1] = LoadActor(THEME:GetPathG("","DifficultyDisplay"))..{
	InitCommand=cmd(draworder,4;rotationz,-90;y,SCREEN_CENTER_Y-144;x,SCREEN_CENTER_X-161;zoom,1;visible,GAMESTATE:GetCurrentGame():GetName() == "pump");
	SongChosenMessageCommand=cmd(stoptweening;accelerate,0.15;y,SCREEN_CENTER_Y-84;x,SCREEN_CENTER_X-284;zoom,1.75);
	TwoPartConfirmCanceledMessageCommand=cmd(stoptweening;decelerate,0.25;y,SCREEN_CENTER_Y-144;x,SCREEN_CENTER_X-161;zoom,1);
	SongUnchosenMessageCommand=cmd(stoptweening;decelerate,0.25;y,SCREEN_CENTER_Y-144;x,SCREEN_CENTER_X-161;zoom,1);
}
t[#t+1] = LoadActor("DifficultyBase")..{}




t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(draworder,98;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+160;zoom,0.75);
	SongChosenMessageCommand=cmd(stoptweening);
	SongUnchosenMessageCommand=cmd(stoptweening);
	TwoPartConfirmCanceledMessageCommand=cmd(stoptweening;);
	--CurrentSongChangedMessageCommand=cmd(diffusealpha,0);
	--CurrentCourseChangedMessageCommand=cmd(diffusealpha,0);
	CurrentSongChangedMessageCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		if song then
			self:diffusealpha(1);
		else
			self:diffusealpha(0);
		end
	end;

	--[[LoadActor("Song Frame") .. {
	InitCommand=cmd(scaletoclipped,268,204;zoom,0.75;stoptweening;decelerate,0.05;zoom,1;rainbow;effectclock,"bgm";effecttiming,7,0,0,0);
	CurrentSongChangedMessageCommand=cmd(playcommand,"Init");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Init");
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Init");
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Init");
	};]]
	
	Def.Sprite {
	InitCommand=cmd(LoadFromSongDisc,GAMESTATE:GetCurrentSong();scaletoclipped,256,192;zoom,0.75;stoptweening;decelerate,0.05;zoom,1);
	CurrentSongChangedMessageCommand=cmd(playcommand,"Init");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Init");
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Init");
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Init");
	};
};

--t[#t+1] = LoadActor("BannerMask")..{
--	InitCommand=cmd(draworder,99;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+133.5;SetSize,306.5,163);
--	OnCommand=cmd(diffusealpha,0;zoom,1.15;linear,0.3;diffusealpha,1;zoom,1;);
	--SongChosenMessageCommand=cmd(linear,0.04;zoom,1.12;);
	--SongUnchosenMessageCommand=cmd(linear,0.15;zoom,1;);
	--TwoPartConfirmCanceledMessageCommand=cmd(linear,0.15;zoom,1;);
	--PlayerJoinedMessageCommand=cmd(playcommand,"On");
--}
--t[#t+1] = LoadActor("mid") .. {
--	InitCommand=cmd(draworder,100;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+3;zoom,0.675);
--}; 


--t[#t+1] = StandardDecorationFromFileOptional("SongTime","SongTime") .. {
	--InitCommand=cmd(draworder,100);
	--SetCommand=function(self)
	--	local curSelection = nil;
	--	local length = 0.0;
	--	if GAMESTATE:IsCourseMode() then
	--	self:diffusealpha(1);				--
	--		curSelection = GAMESTATE:GetCurrentCourse();
	--		self:playcommand("Reset");
	--		if curSelection then
	--			local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber());
	---			if trail then
		--			length = TrailUtil.GetTotalSeconds(trail);
		--		else
	--				length = 0.0;
---				end;
	--		else
--				length = 0.0;
--			end;
--		else
--			self:diffusealpha(1);			--
----			curSelection = GAMESTATE:GetCurrentSong();
--			self:playcommand("Reset");
--			if curSelection then
--				length = curSelection:MusicLengthSeconds();
--				if curSelection:IsLong() then
--					self:playcommand("Long");
--				elseif curSelection:IsMarathon() then
--					self:playcommand("Marathon");
--				else
--					self:playcommand("Reset");
--				end
--			else
--				length = 0.0;
--				self:playcommand("Reset");
--				self:diffusealpha(0);		--
--			end;
--		end;
--		self:settext( SecondsToMSS(length) );
--	end;
--	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
--	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
--	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
--	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
--}


t[#t+1] = StandardDecorationFromFileOptional("NewSong","NewSong") .. {
	SongChosenMessageCommand=cmd(visible,false);
	TwoPartConfirmCanceledMessageCommand=cmd(visible,true);
	SongUnchosenMessageCommand=cmd(visible,true);

	InitCommand=cmd(visible,true;playcommand,"Set");
	BeginCommand=cmd(playcommand,"Set");
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	SetCommand=function(self)
		local sSong;
		if GAMESTATE:GetCurrentSong() then
			if PROFILEMAN:IsSongNew(GAMESTATE:GetCurrentSong()) then
				self:playcommand("Show");
			else
				self:playcommand("Hide");
			end
		else
			self:playcommand("Hide");
		end
	end;
};

t[#t+1] = LoadActor(THEME:GetPathS("","_option select"))..{
CodeMessageCommand = function(self, params)

	if params.PlayerNumber == PLAYER_1 then
		--=============================================================
		if params.Name == 'SpeedUp' then
			self:play()
	
			local P1State = GAMESTATE:GetPlayerState(PLAYER_1);
			local P1Options = P1State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P1State:GetCurrentPlayerOptions():GetXMod()+1).."x";
		
			if Speed == nil then
				Speed = "1.5x";
			end
		
			local XMod = P1State:GetCurrentPlayerOptions():GetXMod()
			if XMod >= 7.25 then
				Speed = "1.5x";
			end
				P1State:SetPlayerOptions("ModsLevel_Preferred", P1Options..","..Speed..","..FailMode());
		end
		--=============================================================
		if params.Name == 'SpeedDown' then
			self:play()
			local P1State = GAMESTATE:GetPlayerState(PLAYER_1);
			local P1Options = P1State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P1State:GetCurrentPlayerOptions():GetXMod()-1).."x";
			if Speed == nil then
				Speed = "1.5x";
			end
			local XMod = P1State:GetCurrentPlayerOptions():GetXMod()
			if XMod <= 2 then
				Speed = "8x";
			end
				P1State:SetPlayerOptions("ModsLevel_Preferred", P1Options..","..Speed..","..FailMode());
		end
		--=============================================================
		if params.Name == 'SpeedHalfUp' then
			self:play()
			local P1State = GAMESTATE:GetPlayerState(PLAYER_1);
			local P1Options = P1State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P1State:GetCurrentPlayerOptions():GetXMod()+0.5).."x";
			if Speed == nil then
				Speed = "1.5x";
			end
			local XMod = P1State:GetCurrentPlayerOptions():GetXMod()
			if XMod >= 7.75 then
				Speed = "1.5x";
			end
				P1State:SetPlayerOptions("ModsLevel_Preferred", P1Options..","..Speed..","..FailMode());
		end
		--=============================================================
		if params.Name == 'SpeedHalfDown' then
			self:play()
			local P1State = GAMESTATE:GetPlayerState(PLAYER_1);
			local P1Options = P1State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P1State:GetCurrentPlayerOptions():GetXMod()-0.5).."x";
			if Speed == nil then
				Speed = "1.5x";
			end
			local XMod = P1State:GetCurrentPlayerOptions():GetXMod()
			if XMod <= 1.5 then
				Speed = "8x";
			end
				P1State:SetPlayerOptions("ModsLevel_Preferred", P1Options..","..Speed..","..FailMode());
		end
		--=============================================================
		if params.Name == 'SpeedQuarterUp' then
			self:play()
			local P1State = GAMESTATE:GetPlayerState(PLAYER_1);
			local P1Options = P1State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P1State:GetCurrentPlayerOptions():GetXMod()+0.25).."x";
			if Speed == nil then
				Speed = "1.5x";
			end
			local XMod = P1State:GetCurrentPlayerOptions():GetXMod()
			if XMod >= 8 then
				Speed = "1.5x";
			end
				P1State:SetPlayerOptions("ModsLevel_Preferred", P1Options..","..Speed..","..FailMode());
		end
		--=============================================================
		if params.Name == 'SpeedQuarterDown' then
			self:play()
			local P1State = GAMESTATE:GetPlayerState(PLAYER_1);
			local P1Options = P1State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P1State:GetCurrentPlayerOptions():GetXMod()-0.25).."x";
			if Speed == nil then
				Speed = "1.5x";
			end
			local XMod = P1State:GetCurrentPlayerOptions():GetXMod()
			if XMod <= 1.5 then
				Speed = "8x";
			end
				P1State:SetPlayerOptions("ModsLevel_Preferred", P1Options..","..Speed..","..FailMode());
		end
		--=============================================================
		--SCREENMAN:SystemMessage(GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptionsString("ModsLevel_Preferred"));
	end
end
}

t[#t+1] = LoadActor(THEME:GetPathS("","_option select"))..{
CodeMessageCommand = function(self, params)
	if params.PlayerNumber == PLAYER_2 then
		--SCREENMAN:SystemMessage(GAMESTATE:GetPlayerState(PLAYER_2):GetPlayerOptionsString("ModsLevel_Preferred"));
		--SCREENMAN:SystemMessage(GAMESTATE:GetPlayerState(PLAYER_2):GetPlayerOptionsArray("ModsLevel_Preferred")[3]);
		--=============================================================
		if params.Name == 'SpeedUp' then
			self:play()
	
			local P2State = GAMESTATE:GetPlayerState(PLAYER_2);
			local P2Options = P2State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P2State:GetCurrentPlayerOptions():GetXMod()+1).."x";
		
			if Speed == nil then
				Speed = "1.5x";
			end
		
			local XMod = P2State:GetCurrentPlayerOptions():GetXMod()
			if XMod >= 7.25 then
				Speed = "1.5x";
			end
			

				P2State:SetPlayerOptions("ModsLevel_Preferred", P2Options..","..Speed..","..FailMode());

			
		end
		--=============================================================
		if params.Name == 'SpeedDown' then
			self:play()
			
			local P2State = GAMESTATE:GetPlayerState(PLAYER_2);
			local P2Options = P2State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P2State:GetCurrentPlayerOptions():GetXMod()-1).."x";
		
			if Speed == nil then
				Speed = "1.5x";
			end
		
			local XMod = P2State:GetCurrentPlayerOptions():GetXMod()
			if XMod <= 2 then
				Speed = "8x";
			end
		

				P2State:SetPlayerOptions("ModsLevel_Preferred", P2Options..","..Speed..","..FailMode());

			
		end
		--=============================================================
		if params.Name == 'SpeedHalfUp' then
			self:play()
			
			local P2State = GAMESTATE:GetPlayerState(PLAYER_2);
			local P2Options = P2State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P2State:GetCurrentPlayerOptions():GetXMod()+0.5).."x";

			if Speed == nil then
				Speed = "1.5x";
			end
		
			local XMod = P2State:GetCurrentPlayerOptions():GetXMod()
			if XMod >= 7.75 then
				Speed = "1.5x";
			end
			

				P2State:SetPlayerOptions("ModsLevel_Preferred", P2Options..","..Speed..","..FailMode());


				
		end
		--=============================================================
		if params.Name == 'SpeedHalfDown' then
			self:play()
			
			local P2State = GAMESTATE:GetPlayerState(PLAYER_2);
			local P2Options = P2State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P2State:GetCurrentPlayerOptions():GetXMod()-0.5).."x";

			if Speed == nil then
				Speed = "1.5x";
			end
		
			local XMod = P2State:GetCurrentPlayerOptions():GetXMod()
			if XMod <= 1.5 then
				Speed = "8x";
			end
			

				P2State:SetPlayerOptions("ModsLevel_Preferred", P2Options..","..Speed..","..FailMode());
	
			
		end
		--=============================================================
		if params.Name == 'SpeedQuarterUp' then
			self:play()
			
			local P2State = GAMESTATE:GetPlayerState(PLAYER_2);
			local P2Options = P2State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P2State:GetCurrentPlayerOptions():GetXMod()+0.25).."x";

			if Speed == nil then
				Speed = "1.5x";
			end
		
			local XMod = P2State:GetCurrentPlayerOptions():GetXMod()
			if XMod >= 8 then
				Speed = "1.5x";
			end
			
			
	
				P2State:SetPlayerOptions("ModsLevel_Preferred", P2Options..","..Speed..","..FailMode());
	
			
		end
		--=============================================================
		if params.Name == 'SpeedQuarterDown' then
			self:play()
			
			local P2State = GAMESTATE:GetPlayerState(PLAYER_2);
			local P2Options = P2State:GetPlayerOptionsString("ModsLevel_Preferred");
			local Speed = (P2State:GetCurrentPlayerOptions():GetXMod()-0.25).."x";

			if Speed == nil then
				Speed = "1.5x";
			end
		
			local XMod = P2State:GetCurrentPlayerOptions():GetXMod()
			if XMod <= 1.5 then
				Speed = "8x";
			end
			
			
	
				P2State:SetPlayerOptions("ModsLevel_Preferred", P2Options..","..Speed..","..FailMode());
		
			
		end
		--=============================================================
		
	end
end
}


--enabled again because noteskins aren't working
--requires further testing
t[#t+1] = LoadActor(THEME:GetPathS("","_option select"))..{
	CodeMessageCommand=function(self,params)
		if params.Name == 'GameLevelUp' then 
			if GetUserPref("UserPrefGameLevel") == "Pro" then
				self:play()
				SetUserPref("UserPrefGameLevel","Ultimate");
				WritePrefToFile("UserPrefGameLevel","Ultimate");	
				SCREENMAN:SystemMessage("Game Level changed to ULTIMATE");		
			end
			if GetUserPref("UserPrefGameLevel") == "Standard" then
				self:play()
				SetUserPref("UserPrefGameLevel","Pro");
				WritePrefToFile("UserPrefGameLevel","Pro");	
				SCREENMAN:SystemMessage("Game Level changed to PRO");		
			end
			if GetUserPref("UserPrefGameLevel") == "Beginner" then
				self:play()
				SetUserPref("UserPrefGameLevel","Standard");
				WritePrefToFile("UserPrefGameLevel","Standard");	
				SCREENMAN:SystemMessage("Game Level changed to STANDARD");		
			end		
		end;
	end
};

t[#t+1] = LoadActor(THEME:GetPathS("","_option select"))..{
	CodeMessageCommand=function(self,params)
		--SCREENMAN:SystemMessage("sdfsdf");
		if params.Name == 'GameLevelDown' then 
			if GetUserPref("UserPrefGameLevel") == "Standard" then
				self:play()
				SetUserPref("UserPrefGameLevel","Beginner");
				WritePrefToFile("UserPrefGameLevel","Beginner");	
				SCREENMAN:SystemMessage("Game Level changed to BEGINNER");		
			end
			if GetUserPref("UserPrefGameLevel") == "Pro" then
				self:play()
				SetUserPref("UserPrefGameLevel","Standard");
				WritePrefToFile("UserPrefGameLevel","Standard");	
				SCREENMAN:SystemMessage("Game Level changed to STANDARD");		
			end
			if GetUserPref("UserPrefGameLevel") == "Ultimate" then
				self:play()
				SetUserPref("UserPrefGameLevel","Pro");
				WritePrefToFile("UserPrefGameLevel","Pro");	
				SCREENMAN:SystemMessage("Game Level changed to PRO");		
			end		
		end;
	end
};

t[#t+1] = LoadActor(THEME:GetPathS("","_mode select"))..{
CodeMessageCommand = function(self, params)
	if params.Name == 'OpenOpList' then
	--if params.PlayerNumber == pn then
	SCREENMAN:GetTopScreen():OpenOptionsList(params.PlayerNumber)
	end
end;
};

--[[ 
--next/prev indicator
t[#t+1] = LoadActor(THEME:GetPathG("","downTap"))..{
	InitCommand=cmd(draworder,100;x,SCREEN_CENTER_X-156;y,SCREEN_CENTER_Y+130;zoom,0.55);
	PreviousSongMessageCommand=cmd(stoptweening;x,SCREEN_CENTER_X-159;sleep,0.12;decelerate,0.2;x,SCREEN_CENTER_X-156);
}

t[#t+1] = LoadActor(THEME:GetPathG("","downTap"))..{
	InitCommand=cmd(draworder,100;x,SCREEN_CENTER_X+156;y,SCREEN_CENTER_Y+130;zoomy,0.55;zoomx,-0.55);
	NextSongMessageCommand=cmd(stoptweening;x,SCREEN_CENTER_X+159;sleep,0.12;decelerate,0.2;x,SCREEN_CENTER_X+156);
}

]]--




--t[#t+1] = LoadActor("light_mid") .. {
--	InitCommand=cmd(draworder,110;x,SCREEN_CENTER_X;effectclock,"bgm";vertalign,top;zoom,0.675;blend,Blend.Add;diffuseshift;effectcolor1,color("#FFFFFF55");effectcolor2,color("#FFFFFFCC");diffusealpha,0.5;);
--}

t[#t+1] = Def.ActorFrame{
		InitCommand=cmd(playcommand,"Check");
		CoinModeChangedMessageCommand=cmd(playcommand,"Check");
		CheckCommand=function(self)
			if GAMESTATE:GetCoinMode() == 'CoinMode_Pay' or GAMESTATE:GetCoinMode() == 'CoinMode_Free' then
				PREFSMAN:SetPreference("CoinMode","CoinMode_Home");
			end
	
		end
};


--[[speedmods
t[#t+1] = LoadActor("optionIcon")..{
	InitCommand=cmd(draworder,102;x,SCREEN_LEFT+5;y,SCREEN_CENTER_Y-64;zoomy,0.34;zoomx,0.425;horizalign,left;diffusealpha,0.75;visible,GAMESTATE:IsHumanPlayer(PLAYER_1));
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1));
	}
t[#t+1] = LoadActor("optionIcon")..{
	InitCommand=cmd(draworder,102;x,SCREEN_RIGHT-5;y,SCREEN_CENTER_Y-64;zoomy,0.34;zoomx,0.425;horizalign,right;diffusealpha,0.75;visible,GAMESTATE:IsHumanPlayer(PLAYER_2));
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2));
	}
	
 -- reminder:
 -- shit isn't working, enable only when GetNoteSkin() is working again --

--noteskin 
t[#t+1] = LoadActor("optionIcon")..{
	InitCommand=cmd(draworder,102;x,SCREEN_LEFT+5;y,SCREEN_CENTER_Y-53;zoomy,0.34;zoomx,0.425;horizalign,left;diffusealpha,0.75;visible,GAMESTATE:IsHumanPlayer(PLAYER_1));
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1));
	}
t[#t+1] = LoadActor("optionIcon")..{
	InitCommand=cmd(draworder,102;x,SCREEN_RIGHT-5;y,SCREEN_CENTER_Y-53;zoomy,0.34;zoomx,0.425;horizalign,right;diffusealpha,0.75;visible,GAMESTATE:IsHumanPlayer(PLAYER_2));
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2));
}
]]

t[#t+1] = Def.ActorFrame{
InitCommand=cmd(x,SCREEN_LEFT+30;y,SCREEN_CENTER_Y-58;draworder,102;zoom,0.575);
	Def.Sprite{
		OnCommand=cmd(croptop,0.32;cropright,0.210;sleep,0.1;diffusebottomedge,1,1,1,0.5;queuecommand,"Update");
		OptionsListClosedMessageCommand=cmd(queuecommand,"Update");
		PlayerJoinedMessageCommand=cmd(queuecommand,"Update");
		CodeMessageCommand=cmd(queuecommand,"Update");
		--PlayerOptionsChangedMessageCommand=cmd(queuecommand,"Update");
		UpdateCommand=function(self)
		self:visible(GAMESTATE:IsHumanPlayer(PLAYER_1));
		
		local P1State = GAMESTATE:GetPlayerState(PLAYER_1);
		local P1Options = P1State:GetPlayerOptionsString("ModsLevel_Preferred");
		
		P1State:SetPlayerOptions("ModsLevel_Preferred", P1Options..","..FailMode());
		
		if GetUserPref("UserPrefGameLevel") == "Ultimate" then
			skinP1 = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptionsArray("ModsLevel_Preferred")[2];
		else
			skinP1 = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptionsArray("ModsLevel_Preferred")[3];
		end
		
		SCREENMAN:SystemMessage(FailMode().." - "..skinP1);
		
		if skinP1 == nil then
			skinP1 = "default";
		end;
	
	self:Load(NOTESKIN:GetPathForNoteSkin("UpLeft", "Hold BottomCap Active", skinP1));
	--"NoteSkins/"..GAMESTATE:GetCurrentGame():GetName().."/"..skin.."/UpLeft Tap Note"
	end;
	};
};

t[#t+1] = Def.ActorFrame{
InitCommand=cmd(x,SCREEN_RIGHT-22;y,SCREEN_CENTER_Y-58;draworder,102;zoom,0.575);
	Def.Sprite{
		OnCommand=cmd(croptop,0.32;cropright,0.22;sleep,0.1;fadebottom,0.4;diffusebottomedge,1,1,1,0.5;queuecommand,"Update");
		OptionsListClosedMessageCommand=cmd(queuecommand,"Update");
		PlayerJoinedMessageCommand=cmd(queuecommand,"Update");
		CodeMessageCommand=cmd(queuecommand,"Update");
		--PlayerOptionsChangedMessageCommand=cmd(queuecommand,"Update");
		UpdateCommand=function(self)
		self:visible(GAMESTATE:IsHumanPlayer(PLAYER_2));
		
		local P2State = GAMESTATE:GetPlayerState(PLAYER_2);
		local P2Options = P2State:GetPlayerOptionsString("ModsLevel_Preferred");
		
		P2State:SetPlayerOptions("ModsLevel_Preferred", P2Options..","..FailMode());
		
		if GetUserPref("UserPrefGameLevel") == "Ultimate" then
			skinP2 = GAMESTATE:GetPlayerState(PLAYER_2):GetPlayerOptionsArray("ModsLevel_Preferred")[2];
		else
			skinP2 = GAMESTATE:GetPlayerState(PLAYER_2):GetPlayerOptionsArray("ModsLevel_Preferred")[3];
		end
		
		if skinP2 == nil then
			skinP2 = "default";
		end;
	
	
	self:Load(NOTESKIN:GetPathForNoteSkin("UpLeft", "Hold BottomCap Active", skinP2));
	--"NoteSkins/"..GAMESTATE:GetCurrentGame():GetName().."/"..skin.."/UpLeft Tap Note"
	end;
	};
};
	
	
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(draworder,102;x,SCREEN_LEFT+27;y,SCREEN_CENTER_Y-22;zoomx,0.41;zoomy,0.38;diffusebottomedge,0.7,0.7,0.7,1;maxwidth,55;shadowlength,0.8);
	OnCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);settext,(math.ceil(GAMESTATE:GetPlayerState(PLAYER_1):GetCurrentPlayerOptions():GetXMod()*100)/100).."x");
	--sleep,0.1;queuecommand,"On");
	OptionsListClosedMessageCommand=cmd(settext,(math.ceil(GAMESTATE:GetPlayerState(PLAYER_1):GetCurrentPlayerOptions():GetXMod()*100)/100).."x");
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);settext,(math.ceil(GAMESTATE:GetPlayerState(PLAYER_1):GetCurrentPlayerOptions():GetXMod()*100)/100).."x");
	CodeMessageCommand=function(self)
		self:stoptweening()
		self:visible(GAMESTATE:IsHumanPlayer(PLAYER_1));
		self:settext((math.ceil(GAMESTATE:GetPlayerState(PLAYER_1):GetCurrentPlayerOptions():GetXMod()*100)/100).."x");
	end;
}
t[#t+1] = LoadFont("RX")..{
	InitCommand=cmd(draworder,102;x,SCREEN_RIGHT-26;y,SCREEN_CENTER_Y-22;zoomx,0.41;zoomy,0.38;diffusebottomedge,0.7,0.7,0.7,1;maxwidth,55;shadowlength,0.8);
	OnCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);settext,(math.ceil(GAMESTATE:GetPlayerState(PLAYER_2):GetCurrentPlayerOptions():GetXMod()*100)/100).."x");
	--sleep,0.1;queuecommand,"On");
	OptionsListClosedMessageCommand=cmd(settext,(math.ceil(GAMESTATE:GetPlayerState(PLAYER_2):GetCurrentPlayerOptions():GetXMod()*100)/100).."x");
	PlayerJoinedMessageCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);settext,(math.ceil(GAMESTATE:GetPlayerState(PLAYER_2):GetCurrentPlayerOptions():GetXMod()*100)/100).."x");
	CodeMessageCommand=function(self)
		self:stoptweening()
		self:visible(GAMESTATE:IsHumanPlayer(PLAYER_2));
		self:settext((math.ceil(GAMESTATE:GetPlayerState(PLAYER_2):GetCurrentPlayerOptions():GetXMod()*100)/100).."x");
	end;
	
}



t[#t+1] = LoadActor("optionFlash")..{
	InitCommand=cmd(draworder,102;x,SCREEN_LEFT+26;y,SCREEN_CENTER_Y-22;zoomy,0.34;zoomx,0.425;diffuse,1,1,1,0;visible,GAMESTATE:IsHumanPlayer(PLAYER_1);sleep,0.1;blend,Blend.Add;queuecommand,"Init");
	CodeMessageCommand=function(self,params)
	if params.PlayerNumber == PLAYER_1 then
		if params.Name == 'SpeedUp' or 
		params.Name == 'SpeedDown' or
		params.Name == 'SpeedHalfUp' or 
		params.Name == 'SpeedHalfDown' or	
		params.Name == 'SpeedQuarterUp' or 
		params.Name == 'SpeedQuarterDown' then
		self:stoptweening();
		self:diffusealpha(1);
		self:sleep(0.1);
		self:linear(0.3)
		self:diffusealpha(0);	
		end
	end
	end
}
t[#t+1] = LoadActor("optionFlash")..{
	InitCommand=cmd(draworder,102;x,SCREEN_RIGHT-26;y,SCREEN_CENTER_Y-22;zoomy,0.34;zoomx,0.425;diffuse,1,1,1,0;visible,GAMESTATE:IsHumanPlayer(PLAYER_2);sleep,0.1;blend,Blend.Add;queuecommand,"Init");
	CodeMessageCommand=function(self,params)
	if params.PlayerNumber == PLAYER_2 then
		if params.Name == 'SpeedUp' or 
		params.Name == 'SpeedDown' or
		params.Name == 'SpeedHalfUp' or 
		params.Name == 'SpeedHalfDown' or	
		params.Name == 'SpeedQuarterUp' or 
		params.Name == 'SpeedQuarterDown' then
		self:stoptweening();
		self:diffusealpha(1);
		self:sleep(0.1);
		self:linear(0.3)
		self:diffusealpha(0);	
		end
	end
	end
}


--System
for pn in ivalues(PlayerNumber) do

---LIST
t[#t+1] = Def.Quad{
		InitCommand=cmd(draworder,25;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH/3+32,SCREEN_HEIGHT;diffuse,0,0,0,.9;diffusealpha,0);
		OpenCommand=cmd(stoptweening;decelerate,0.3;diffusealpha,1);
		OptionsListOpenedMessageCommand=function(self,params)
			if params.Player == pn then
				if pn == PLAYER_1 then
					self:horizalign(left);
					self:x(SCREEN_LEFT);
					self:faderight(0.33);
					self:fadeleft(0);
				elseif pn == PLAYER_2 then
					self:horizalign(right);
					self:x(SCREEN_RIGHT);
					self:faderight(0);
					self:fadeleft(0.33);
				end
				self:playcommand("Open");
			end
		end;
		OptionsListClosedMessageCommand=function(self,params)
			if params.Player == pn then
				self:stoptweening();
				self:accelerate(0.25);
				self:diffusealpha(0);
			end
		end;
}

end

t[#t+1] = LoadActor(THEME:GetPathS("","_option change"))..{
	PreviousGroupMessageCommand=cmd(play);
	NextGroupMessageCommand=cmd(play);
	SongChosenMessageCommand=cmd(play);
	StepsChosenMessageCommand=cmd(play);
	--OptionsListOpenedMessageCommand=cmd(play);
	--OptionsListClosedMessageCommand=cmd(play);	
	--OptionsListQuickChangeMessageCommand=cmd(play);	
}

t[#t+1] = LoadActor(THEME:GetPathS("","_menu change"))..{
	--OptionsListRightMessageCommand=cmd(play);
	--OptionsListLeftMessageCommand=cmd(play);	
}
t[#t+1] = LoadActor(THEME:GetPathS("","_option select"))..{
	--OptionsListClosedMessageCommand=cmd(play);	
	--OptionsListStartMessageCommand=cmd(play);
	OptionsListResetMessageCommand=cmd(play);	
}
t[#t+1] = LoadActor(THEME:GetPathS("","_menu select"))..{
	OptionsListPopMessageCommand=cmd(play);
	OptionsListPushMessageCommand=cmd(play);	
}
t[#t+1] = LoadActor(THEME:GetPathS("","_mode change"))..{
	SongUnchosenMessageCommand=cmd(play);
}
t[#t+1] = LoadActor(THEME:GetPathS("","Common start"))..{
		PlayerJoinedMessageCommand=cmd(play);
		OffCommand=cmd(play);
}

return t
